/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.entity;

import cofh.lib.entity.AbstractMinecartCoFH;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.thermal.locomotion.init.TLocReferences;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class FluidMinecart
extends AbstractMinecartCoFH {
    public static final int BASE_CAPACITY = 64000;
    protected FluidStorageCoFH fluidStorage = new FluidStorageCoFH(64000);
    protected LazyOptional<?> fluidCap = LazyOptional.empty();

    public FluidMinecart(EntityType<? extends FluidMinecart> type, Level worldIn) {
        super(type, worldIn);
    }

    public FluidMinecart(Level worldIn, double posX, double posY, double posZ) {
        super(TLocReferences.FLUID_CART_ENTITY, worldIn, posX, posY, posZ);
    }

    public FluidMinecart onPlaced(ItemStack stack) {
        super.onPlaced(stack);
        Map enchantMap = EnchantmentHelper.m_44882_((ListTag)this.enchantments);
        float holdingMod = this.getHoldingMod(enchantMap);
        this.fluidStorage.applyModifiers(holdingMod);
        if (stack.m_41783_() != null) {
            this.fluidStorage.read(stack.m_41783_());
        }
        return this;
    }

    public FluidStack getFluidStack() {
        return this.fluidStorage.getFluidStack();
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        this.fluidStorage.write(stack.m_41784_());
        return super.createItemStackTag(stack);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Map enchantMap = EnchantmentHelper.m_44882_((ListTag)this.enchantments);
        float holdingMod = this.getHoldingMod(enchantMap);
        this.fluidStorage.applyModifiers(holdingMod);
        this.fluidStorage.read(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.fluidStorage.write(compound);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)TLocReferences.FLUID_CART_ITEM);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.fluidCap.isPresent() && this.fluidStorage.getCapacity() > 0) {
                this.fluidCap = LazyOptional.of(() -> this.fluidStorage);
            }
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidCap.invalidate();
    }
}

